<?php

namespace App\Policies;

use App\Models\CustomData;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Support\Facades\Gate;

class CustomDataPolicy
{
    use HandlesAuthorization;

    public function haveAnyImport(User $user): bool
    {
        return $user->can('data.import') || $user->can('data.import.all');
    }
    public function viewAll(User $user): bool
    {
        return $user->can('data.view.all');
    }
    public function exportAll(User $user): bool
    {
        return $user->can('data.export.all');
    }
    public function importAll(User $user): bool
    {
        return $user->can('data.import.all');
    }

    public function view(User $user, CustomData $data): bool
    {
        return $user->can('data.view') && $data->user_id === $user->id;
    }


    public function create(User $user): bool
    {
        return $user->can('data.create');
    }

    public function edit(User $user): bool
    {
        return $user->can('data.edit');
    }

    public function delete(User $user): bool
    {
        return $user->can('data.delete');
    }

    public function export(User $user, CustomData $data): bool
    {
        return $user->can('data.export') && $data->user_id === $user->id;
    }

    public function import(User $user, CustomData $data): bool
    {
        return $user->can('data.import') && $data->user_id === $user->id;
    }
}
