<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Spatie\Permission\Models\Role;

class UserController extends Controller
{
    public function index(Request $request)
    {
        Gate::authorize('view', User::class);
        if($request->ajax()) {
            $users = User::with('roles')->get();
            return response()->json($users);
        }
        return view('users');
    }

    public function create()
    {
    }

    public function store(Request $request)
    {
        Gate::authorize('create', User::class);
        try {
            DB::beginTransaction();
            $user = User::create([
                'name' => $request->name,
                'email' => $request->email,
                'password' => $request->password,
            ]);
            $role = Role::findById($request->role_id);
            $user->syncRoles([$role->name]);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            return response()->json($th, 500);
        } catch (\Throwable $e) {
            return response()->json($e, 400);
        }
        return response()->json($user->load(['roles']));
    }

    public function show($id)
    {
    }

    public function edit($id)
    {
    }

    public function update(Request $request, $id)
    {
        Gate::authorize('edit', User::class);
        try {
            $user = User::find($id);
            if (!$user) {
                return response()->json(['error' => 'User not found'], 404);
            }

            $user->update([
                'name' => $request->name,
                'email' => $request->email,
            ]);
            $role = Role::findById($request->role_id);
            $user->syncRoles([$role->name]);

            return response()->json($user->load(['roles']));
        } catch (\Throwable $th) {
            return response()->json(['error' => $th->getMessage()], 500);
        }
    }

    public function destroy($id)
    {
        Gate::authorize('delete', User::class);
        try {
            DB::beginTransaction();
            $user = User::find($id);
            $user->delete();
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            return response()->json($th, 500);
        } catch (\Throwable $e) {
            return response()->json($e, 400);
        }
        return response()->json('User deleted successfully');
    }
}
