<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    public function login()
    {
        // return 10;
        return view('auth.login');
    }

    public function authenticate(Request $request)
    {
        // dd($request->all());
        $request->validate([
            'email' => 'required|email|max:255|exists:users,email',
            //   'password' => ['required', Password::min(8)->max(16)->mixedCase()->numbers()->symbols()],
        ]);
        if (Auth::attempt($request->only('email', 'password'), $request->remember)) {

            return redirect()->route('dashboard')->with('email', 'You have been logged in successfully');
        }
        return redirect()->back()->withErrors(['email' => 'Invalid credentials']);
    }

    public function logout()
    {
        Auth::logout();
        return redirect()->route('login')->with('success', 'You have been logged out successfully');
    }
}
