async function loadReadme(filePath) {
  const response = await fetch(filePath);
  const markdown = await response.text();
  document.getElementById("readme-content").innerHTML = marked.parse(markdown);

  document.querySelectorAll("a").forEach((link) => {
    const href = link.getAttribute("href");

    if (href && href.includes("#")) {
      const hash = href.split("#")[1];
      const targetElementText = link.textContent.trim();
      const xpath = `//*[text()="${targetElementText}"]`;
      const matchingElements = document.evaluate(xpath, document, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);

      for (let i = 0; i < matchingElements.snapshotLength; i++) {
        if (matchingElements.snapshotItem(i).nodeName != "A" && matchingElements.snapshotItem(i)) {
          matchingElements.snapshotItem(i).id = hash;
        }
      }
    }
  });

  document.querySelectorAll("pre code").forEach((block) => {
    hljs.highlightElement(block);

    const copyBtn = document.createElement("button");
    copyBtn.innerText = "Copy";
    copyBtn.classList.add("copy-btn");
    block.parentElement.style.position = "relative";
    block.parentElement.appendChild(copyBtn);

    copyBtn.addEventListener("click", () => {
      navigator.clipboard.writeText(block.innerText).then(() => {
        copyBtn.innerText = "Copied!";
        setTimeout(() => {
          copyBtn.innerText = "Copy";
        }, 2000);
      });
    });
  });
}
